"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_CONFIG = void 0;
var _package = require("../package.json");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const DEFAULT_CONFIG = exports.DEFAULT_CONFIG = {
  searchguard: {
    enabled: true,
    sg_frontend_config_id: "default",
    frontend_base_url: null,
    allow_client_certificates: false,
    readonly_mode: {
      enabled: true,
      roles: []
    },
    xff: {
      enabled: true
    },
    cookie: {
      secure: false,
      password: 'searchguard_cookie_default_password',
      name: 'searchguard_authentication',
      ttl: null,
      isSameSite: 'Lax'
    },
    auth: {
      // @todo This is still being used in the FE, does it really work?
      type: 'default',
      anonymous_auth_enabled: false,
      unauthenticated_routes: ['/api/status', '/internal/security/me'],
      debug: false,
      jwt_param: {
        enabled: false,
        url_param: 'authorization'
      }
    },
    basicauth: {
      forbidden_usernames: [],
      allowed_usernames: null
    },
    multitenancy: {
      debug: false
    },
    configuration: {
      enabled: true,
      action_groups_page: {
        enabled: true
      },
      create_action_groups_page: {
        enabled: true
      },
      internal_users_page: {
        enabled: true
      },
      create_internal_users_page: {
        enabled: true
      },
      roles_page: {
        enabled: true
      },
      create_roles_page: {
        enabled: true
      },
      role_mappings_page: {
        enabled: true
      },
      create_role_mappings_page: {
        enabled: true
      },
      tenants_page: {
        enabled: true
      },
      create_tenants_page: {
        enabled: true
      },
      system_status_page: {
        enabled: true
      },
      license_page: {
        enabled: true
      },
      cache_page: {
        enabled: true
      }
    },
    accountinfo: {
      enabled: true
    },
    sgVersion: _package.version
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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